//
//  Grid Spline.js
//
//  v.080708 first version

//  (c) 2008 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 
// for scripts/Splineobj Folder

// for debugging
Vec2D.prototype.toString = function() {
	return this.u.toFixed(4) + ', ' + this.v.toFixed(4);
}
Vec3D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4);
}
Vec4D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4) + ', ' + this.w.toFixed(4);
}
//

function buildUI(obj) {
    
    obj.setParameter("name","Grid Spline");
    
    obj.addParameterFloat("grid size",10,0,1000,true,true);
    obj.addParameterFloat("step size",1.0,0,1000,true,true);
    obj.addParameterSelector("grid type",['plane grid','3D grid'],true,true);
}

function buildObject(obj) {
	var size = obj.getParameter("grid size");
	var step_size = obj.getParameter("step size");
	var grid_type = parseInt(obj.getParameter("grid type"));
	var size_h = size/2;
	var steps = Math.floor(size_h / step_size);
	
	var core = obj.core();
	
	print('steps:'+steps);
	if (grid_type == 1) { // 3d type
		for (var i = 0;i < steps+1;i++) {
			for (var j = 0;j < steps+1;j++) {
				// positive
				core.move(new Vec3D(i*step_size, -size_h, j*step_size));
				core.line(new Vec3D(i*step_size,  size_h, j*step_size));
				core.move(new Vec3D(j*step_size, i*step_size,  size_h));
				core.line(new Vec3D(j*step_size, i*step_size, -size_h));
				core.move(new Vec3D(-size_h, j*step_size, i*step_size));
				core.line(new Vec3D( size_h, j*step_size, i*step_size));
				// negative
				if (i != 0) {
					core.move(new Vec3D(i*-step_size, -size_h, j*step_size));
					core.line(new Vec3D(i*-step_size,  size_h, j*step_size));
					core.move(new Vec3D(j*step_size, i*-step_size,  size_h));
					core.line(new Vec3D(j*step_size, i*-step_size, -size_h));
					core.move(new Vec3D(-size_h, j*step_size, i*-step_size));
					core.line(new Vec3D( size_h, j*step_size, i*-step_size));
				}
				if (j != 0) {
					core.move(new Vec3D(i*step_size, -size_h, j*-step_size));
					core.line(new Vec3D(i*step_size,  size_h, j*-step_size));
					core.move(new Vec3D(j*-step_size, i*step_size,  size_h));
					core.line(new Vec3D(j*-step_size, i*step_size, -size_h));
					core.move(new Vec3D(-size_h, j*-step_size, i*step_size));
					core.line(new Vec3D( size_h, j*-step_size, i*step_size));
				}
				if (i != 0 && j != 0) {
					core.move(new Vec3D(i*-step_size, -size_h, j*-step_size));
					core.line(new Vec3D(i*-step_size,  size_h, j*-step_size));
					core.move(new Vec3D(j*-step_size, i*-step_size,  size_h));
					core.line(new Vec3D(j*-step_size, i*-step_size, -size_h));
					core.move(new Vec3D(-size_h, j*-step_size, i*-step_size));
					core.line(new Vec3D( size_h, j*-step_size, i*-step_size));
				}
			}
		}
	} else { // plane type
		for (var i = 0;i < steps+1;i++) {
			core.move(new Vec3D(i*step_size, -size_h, 0));
			core.line(new Vec3D(i*step_size,  size_h, 0));
			core.move(new Vec3D(i*step_size, 0,  size_h));
			core.line(new Vec3D(i*step_size, 0, -size_h));
			
			core.move(new Vec3D(0, i*step_size,  size_h));
			core.line(new Vec3D(0, i*step_size, -size_h));
			core.move(new Vec3D(-size_h, i*step_size, 0));
			core.line(new Vec3D( size_h, i*step_size, 0));
			
			core.move(new Vec3D(-size_h, 0, i*step_size));
			core.line(new Vec3D( size_h, 0, i*step_size));
			core.move(new Vec3D(0, -size_h, i*step_size));
			core.line(new Vec3D(0,  size_h, i*step_size));
			
			if (i != 0) {
				core.move(new Vec3D(i*-step_size, -size_h, 0));
				core.line(new Vec3D(i*-step_size,  size_h, 0));
				core.move(new Vec3D(i*-step_size, 0,  size_h));
				core.line(new Vec3D(i*-step_size, 0, -size_h));
				
				core.move(new Vec3D(0, i*-step_size,  size_h));
				core.line(new Vec3D(0, i*-step_size, -size_h));
				core.move(new Vec3D(-size_h, i*-step_size, 0));
				core.line(new Vec3D( size_h, i*-step_size, 0));
				
				core.move(new Vec3D(-size_h, 0, i*-step_size));
				core.line(new Vec3D( size_h, 0, i*-step_size));
				core.move(new Vec3D(0, -size_h, i*-step_size));
				core.line(new Vec3D(0,  size_h, i*-step_size));
			}
		}
	}
}

